<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #1a1a2e; color: white; padding: 20px; text-align: center; }
        .content { padding: 30px; background: #f9f9f9; text-align: center; }
        .footer { text-align: center; padding: 15px; font-size: 12px; color: #999; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header"><h2>¡Gracias por contactarnos!</h2></div>
        <div class="content">
            <p>Hola <strong><?php echo e($lead->name); ?></strong>,</p>
            <p>Hemos recibido tu solicitud de visita para el <strong><?php echo e(\Carbon\Carbon::parse($lead->visit_date)->format('d/m/Y \a \l\a\s H:i')); ?></strong>.</p>
            <p>En breve estaremos comunicándonos contigo para confirmar la visita.</p>
            <p>Si tienes alguna pregunta puedes contactarnos directamente.</p>
            <br>
            <p>El equipo de <strong>Confinca</strong></p>
        </div>
        <div class="footer">Confinca - Tu aliado inmobiliario</div>
    </div>
</body>
</html><?php /**PATH /var/www/html/confinca/resources/views/emails/lead-client.blade.php ENDPATH**/ ?>