<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #1a1a2e; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background: #f9f9f9; }
        .field { margin-bottom: 15px; }
        .label { font-weight: bold; color: #555; }
        .footer { text-align: center; padding: 15px; font-size: 12px; color: #999; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header"><h2>Nuevo Contacto Recibido</h2></div>
        <div class="content">
            <div class="field"><div class="label">Nombre</div><div><?php echo e($lead->name); ?></div></div>
            <div class="field"><div class="label">Teléfono</div><div><?php echo e($lead->phone); ?></div></div>
            <div class="field"><div class="label">Email</div><div><?php echo e($lead->email); ?></div></div>
            <div class="field"><div class="label">Fecha de visita solicitada</div><div><?php echo e(\Carbon\Carbon::parse($lead->visit_date)->format('d/m/Y H:i')); ?></div></div>
            <div class="field"><div class="label">Mensaje</div><div><?php echo e($lead->message); ?></div></div>
            <div class="field"><div class="label">Propiedad</div><div>#<?php echo e($lead->property->code ?? $lead->property_id); ?> - <?php echo e($lead->property->address ?? ''); ?></div></div>
            <div class="field"><div class="label">Agente</div><div><?php echo e($lead->agent->name ?? ''); ?></div></div>
        </div>
        <div class="footer">Confinca - Sistema de gestión de leads</div>
    </div>
</body>
</html><?php /**PATH /var/www/html/confinca/resources/views/emails/lead-company.blade.php ENDPATH**/ ?>