<?php

use App\Http\Controllers\AboutusController;
use App\Http\Controllers\Admin\PropertyInternalController;
use App\Http\Controllers\Admin\PropertyExternalController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\PropertyImageController;
use App\Http\Controllers\PropertyLeadController;
use App\Http\Controllers\PropertyRentController;
use App\Http\Controllers\PropertySaleController;

/*Route::get('/', function () {
    return view('welcome');
});*/


Route::get('/', [WelcomeController::class, 'index'])->name('welcome');

Route::get('/aboutus', [AboutusController::class, 'index'])->name('aboutus');

Route::get('/post', [PostController::class, 'index'])->name('post');
Route::get('post/{slug}', [PostController::class, 'show'])->name('detailpost');

Route::get('/contact', [ContactController::class, 'index'])->name('contact');



/**route admin */


//ventas
Route::get('/property/sale', [PropertySaleController::class, 'index'])->name('sale');

Route::get('/property/rent', [PropertyRentController::class, 'index'])->name('rent');

Route::get('/property/neighborhoods', [PropertySaleController::class, 'getNeighborhoods'])->name('sale.neighborhoods');

Route::get('/search', [WelcomeController::class, 'search'])->name('search');

// Rutas para características internas
// Obtener lista (AJAX)
    Route::get('properties/{property}/internal/list', [PropertyInternalController::class, 'list'])
        ->name('properties.internal.list');
    
    // Guardar (AJAX)
    Route::post('properties/{property}/internal', [PropertyInternalController::class, 'store'])
        ->name('properties.internal.store');
    
    // Eliminar (AJAX)
    Route::delete('properties/{property}/internal/{internal}', [PropertyInternalController::class, 'destroy'])
        ->name('properties.internal.destroy');
        
// Rutas para características externas
// Obtener lista (AJAX)
    Route::get('properties/{property}/external/list', [PropertyExternalController::class, 'list'])
        ->name('properties.external.list');
    
    // Guardar (AJAX)
    Route::post('properties/{property}/external', [PropertyExternalController::class, 'store'])
        ->name('properties.external.store');
    
    // Eliminar (AJAX)
    Route::delete('properties/{property}/external/{external}', [PropertyExternalController::class, 'destroy'])
        ->name('properties.external.destroy');        

//detalle inmueble
Route::get('/property/{id}', [WelcomeController::class, 'show'])->name('property.show');


//leads
Route::post('/property/lead', [PropertyLeadController::class, 'store'])->name('property.lead.store');

