@extends('layouts.app')

@section('title', 'CONFINCA - Inmobiliarias en bucaramanga')

@section('content')



    <!-- slider -->
                <section class="slider home2">
                    <div class="wrap-slider">
                        <div class="slider-item">
                            <div class="cl-container">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="slider-content">
                                            <!--<div class="sub wow fadeInUp">LET US GUIDE YOUR HOME</div>-->  
                                            <h2 class="wow fadeInUp text-white" data-wow-delay="0.1s">{{$banner['title']}}</h2>
                                            <h1 class="wow fadeInUp text-white" data-wow-delay="0.15s">{{ $banner['caption'] }}</h1>                                            
                                            
                                            <form class="form-search-home5 wow fadeInUp" method="GET" action="{{ route('search') }}">
                                                <div class="list">
                                                    <div class="group-form">
                                                        <div class="form-style-has-title">
                                                            <div class="title">Tipo</div>
                                                            <select name="offer" class="nice-select">
                                                                <option value="sale">Venta</option>
                                                                <option value="rent">Arriendo</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="divider-1"></div>
                                                    <div class="group-form">
                                                        <div class="form-style-has-title">
                                                            <div class="title">Tipo Inmueble</div>
                                                            <select name="type" class="nice-select">
                                                                <option value="">Todos los inmuebles</option>
                                                                @foreach($types as $type)
                                                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="divider-1"></div>
                                                    <div class="group-form">
                                                        <div class="form-style-has-title">
                                                            <div class="title">Ciudad</div>
                                                            <select name="city" class="nice-select">
                                                                <option value="">Todas las ciudades</option>
                                                                @foreach($cities as $city)
                                                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="flex gap10">
                                                    <div class="group-form">
                                                        <div class="button-submit">
                                                            <button type="submit">Buscar</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /slider -->

                <section class="tf-section work-with-us">
                    <div class="cl-container">
                        <div class="row">
                            <div class="col-12">
                                <div class="heading-section text-center">
                                    <h2 class="wow fadeInUp">{{ $text->title }}</h2>
                                    <div class="text wow fadeInUp">{{ $text->description }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-center">
                           <div class="col-xl-10">
                            <div class="wrap">
                                @foreach ($column as $col)                              
                                
                                    <div class="box-icon style-1">
                                        <div class="icon has-ellipse">
                                            <i class="{{ $col->icon }}"></i>
                                        </div>
                                        <div class="content wow fadeInUp">
                                            <a href="#" class="title">{{$col->title}}</a> 
                                            <p>{{ $col->description }}</p>
                                        </div>
                                    </div>

                                @endforeach

                            </div>
                           </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="heading-section text-center">
                                    <h2 class="wow fadeInUp">{{ $textt->title }}</h2>
                                    <div class="text wow fadeInUp">{{ $textt->description }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="property-list-wrap-v3">
                            <div class="cl-container">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="row list">
                                            @forelse ($great as $inmueble)
                                            <div class="col-xl-4">
                                                <div class="box-dream has-border wow fadeInUp">
                                                    <div class="image">
                                                        <div class="list-tags">
                                                            <a href="{{ route('property.show', $inmueble->id) }}" class="tags-item for-sell">{{ $inmueble->offer->name }}</a>
                                                        </div>
                                                        <div class="swiper-container slider-box-dream arrow-style-1 pagination-style-1">
                                                            <div class="swiper-wrapper">
                                                                @foreach ($inmueble->images as $image)
                                                                    <div class="swiper-slide">
                                                                        <div class="">
                                                                            <img class="" src="{{ Storage::url($image->image) }}" alt="{{ $image->image }}">
                                                                        </div>
                                                                    </div>
                                                                @endforeach                                                                
                                                            </div>
                                                            <div class="swiper-pagination box-dream-pagination"></div>
                                                            <div class="box-dream-next swiper-button-next"></div>
                                                            <div class="box-dream-prev swiper-button-prev"></div>
                                                        </div>
                                                    </div>
                                                    <div class="content">
                                                        <div class="head">
                                                            <div class="title">
                                                                <a href="{{ route('property.show', $inmueble->id) }}">{{ $inmueble->typeProperty->name }}</a> 
                                                            </div>
                                                        </div>
                                                        <div class="location">
                                                            <div class="icon">
                                                                <i class="flaticon-location"></i>
                                                            </div>
                                                            <p>{{ $inmueble->address }} </p>
                                                        </div>
                                                        <div class="icon-box">
                                                            <div class="item">
                                                                <i class="flaticon-hotel"></i>
                                                                <p>{{ $inmueble->rooms }} Hab.</p> 
                                                            </div>
                                                            <div class="item">
                                                                <i class="flaticon-bath-tub"></i>
                                                                <p>{{ $inmueble->bathrooms }} Baños</p> 
                                                            </div>
                                                            <div class="item">
                                                                <i class="flaticon-minus-front"></i>
                                                                <p>{{ $inmueble->area }} m<sup>2</sup></p>
                                                            </div>
                                                        </div>
                                                        <hr>
                                                        <div class="head">
                                                            <h3>${{number_format($inmueble->price)}}</h3>
                                                            <div class="title">
                                                                <a href="{{ route('property.show', $inmueble->id) }}" class="tf-button-primary" type="submit">Ver Detalles <i class="icon-arrow-right-add"></i></a>
                                                            </div>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @empty
                                                <p>No hay inmuebles para mostrar.</p>
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>   
                        <div class="d-flex justify-content-center gap-2">
                            <a href="{{ route('sale') }}" class="tf-button-primary border-radius-corner wow fadeInUp">
                                Inmuebles en Venta<i class="icon-arrow-right-add"></i>
                            </a>
                            <a href="#" class="tf-button-primary border-radius-corner wow fadeInUp">
                                Inmuebles en Arriendo<i class="icon-arrow-right-add"></i>
                            </a>
                        </div>            
                    </div>
                </section>  
                
                <section class="tf-section perfect-home style-1">
                    <div class="cl-container">
                        <div class="row">
                            <div class="col-lg-7">
                                <div class="wrap-image">
                                    <div class="image mb-20 wow fadeInDown">
                                        <img src="storage/{{ $left->imageone }}" alt="">
                                    </div>
                                    <div class="flex gap20">
                                        <div class="image wow fadeInLeft">
                                            <img src="storage/{{ $left->imagetwo }}" alt="">
                                        </div>
                                        <div class="image wow fadeInRight">
                                            <img src="storage/{{ $left->imagethree }}" alt="">
                                        </div>
                                    </div>
                                    <div class="box wow fadeInUp">
                                        <div class="icon">
                                            <i class="{{ $left->icon }}"></i>
                                        </div>
                                        <div>
                                            <p>{{ $left->title }}</p>
                                            <h4>{{ $left->description }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-5">
                                <div class="content-right">
                                    <h2 class="wow fadeInUp">{{ $title->title }}</h2>
                                    <div class="text-content wow fadeInUp" data-wow-delay="0.1s"> {{ $title->subtitle }}</div>
                                    <div class="list">
                                        @foreach ( $right as $cl )

                                            <div class="box-icon style-2 wow fadeInUp">
                                                <div class="icon has-ellipse small">
                                                    <i class="{{ $cl->icon }}"></i>
                                                </div>
                                                <div class="content">
                                                    <a href="#" class="title">{{ $cl->title }}</a> 
                                                    <p>{{ $cl->description }}</p>
                                                </div>
                                            </div>
                                        
                                        @endforeach                                        
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

@endsection


