@extends('layouts.app')
@section('title', 'CONFINCA - Ventas')
@section('content')

<div class="main-content pt-150">
    <div class="flat-title">
        <div class="cl-container full">
            <div class="row">
                <div class="col-12">
                    <div class="content">
                        <h2>Inmuebles en Venta</h2>
                        <ul class="breadcrumbs">
                            <li><a href="{{ route('welcome') }}">Inicio</a></li>
                            <li>/</li>
                            <li>Listado de inmuebles</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="property-list-wrap v1">
        <div class="cl-container">
            <div class="row">
                {{-- SIDEBAR FILTROS --}}
                <div class="col-lg-4">
                    <form class="form-sidebar-left" method="GET" action="{{ route('sale') }}">
                        <h4>Buscar Inmueble</h4>

                        <div class="wow fadeInUp mb-3" style="z-index:1000">
                            <h6>Tipo de Inmueble</h6>
                            <select name="type" class="w-full">
                                <option value="">Todos</option>
                                @foreach($types as $type)
                                    <option value="{{ $type->id }}" {{ request('type') == $type->id ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:900">
                            <h6>Habitaciones</h6>
                            <select name="rooms" class="w-full">
                                <option value="">Todas</option>
                                @foreach([1,2,3,4,5] as $n)
                                    <option value="{{ $n }}" {{ request('rooms') == $n ? 'selected' : '' }}>{{ $n }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:800">
                            <h6>Baños</h6>
                            <select name="bathrooms" class="w-full">
                                <option value="">Todos</option>
                                @foreach([1,2,3,4,5] as $n)
                                    <option value="{{ $n }}" {{ request('bathrooms') == $n ? 'selected' : '' }}>{{ $n }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="wow fadeInUp mb-3" style="z-index:700">
                            <h6>Ciudad</h6>
                            <select name="city" class="w-full" onchange="this.form.submit()">
                                <option value="">Todas</option>
                                @foreach($cities as $city)
                                    <option value="{{ $city->id }}" {{ request('city') == $city->id ? 'selected' : '' }}>
                                        {{ $city->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        @if($neighborhoods->count())
                        <div class="wow fadeInUp mb-3" style="z-index:600">
                            <h6>Barrio</h6>
                            <select name="neighborhood" class="w-full">
                                <option value="">Todos</option>
                                @foreach($neighborhoods as $neighborhood)
                                    <option value="{{ $neighborhood->id }}" {{ request('neighborhood') == $neighborhood->id ? 'selected' : '' }}>
                                        {{ $neighborhood->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        @endif

                        <div class="grid-2-cols wow fadeInUp mb-3">
                            <fieldset>
                                <input type="number" name="min_price" placeholder="Precio mínimo"
                                       value="{{ request('min_price') }}">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="max_price" placeholder="Precio máximo"
                                       value="{{ request('max_price') }}">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="min_area" placeholder="Área mínima m²"
                                       value="{{ request('min_area') }}">
                            </fieldset>
                            <fieldset>
                                <input type="number" name="max_area" placeholder="Área máxima m²"
                                       value="{{ request('max_area') }}">
                            </fieldset>
                        </div>

                        <button type="submit" class="tf-button-primary w-full wow fadeInUp">
                            Buscar Inmueble <i class="icon-arrow-right-add"></i>
                        </button>

                        @if(request()->hasAny(['type','rooms','bathrooms','city','neighborhood','min_price','max_price','min_area','max_area']))
                            <a href="{{ route('sale') }}" class="tf-button-other w-full wow fadeInUp mt-2">
                                Limpiar filtros
                            </a>
                        @endif
                    </form>
                </div>

                {{-- RESULTADOS --}}
                <div class="col-lg-8">
                    <div class="top">
                        <div class="sub">
                            <p>{{ $sales->total() }} {{ $sales->total() == 1 ? 'Resultado' : 'Resultados' }}</p>
                        </div>
                    </div>

                    <div class="row">
                        @forelse ($sales as $inmueble)
                        <div class="col-xl-6">
                            <div class="box-dream has-border wow fadeInUp">
                                <div class="image">
                                    <div class="list-tags">
                                        <a href="{{ route('property.show', $inmueble->id) }}" class="tags-item for-sell">
                                            {{ $inmueble->offer->name }}
                                        </a>
                                    </div>
                                    <div class="swiper-container slider-box-dream arrow-style-1 pagination-style-1">
                                        <div class="swiper-wrapper">
                                            @foreach ($inmueble->images as $image)
                                            <div class="swiper-slide">
                                                <img src="{{ Storage::url($image->image) }}" alt="">
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="swiper-pagination box-dream-pagination"></div>
                                        <div class="box-dream-next swiper-button-next"></div>
                                        <div class="box-dream-prev swiper-button-prev"></div>
                                    </div>
                                </div>
                                <div class="content">
                                    <div class="head">
                                        <div class="title">
                                            <a href="{{ route('property.show', $inmueble->id) }}">
                                                {{ $inmueble->typeProperty->name }}
                                            </a>
                                        </div>
                                        <div class="price">${{ number_format($inmueble->price) }}</div>
                                    </div>
                                    <div class="location">
                                        <div class="icon"><i class="flaticon-location"></i></div>
                                        <p>{{ $inmueble->address }}</p>
                                    </div>
                                    <div class="icon-box">
                                        <div class="item">
                                            <i class="flaticon-hotel"></i>
                                            <p>{{ $inmueble->rooms }} Hab.</p>
                                        </div>
                                        <div class="item">
                                            <i class="flaticon-bath-tub"></i>
                                            <p>{{ $inmueble->bathrooms }} Baños</p>
                                        </div>
                                        <div class="item">
                                            <i class="flaticon-minus-front"></i>
                                            <p>{{ $inmueble->area }} m²</p>
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="head">
                                        <div class="title">
                                            <a href="https://wa.me/57{{ $inmueble->agent->phone }}?text=Hola, estoy interesado en la propiedad: {{ urlencode($inmueble->code) }}"" class="tf-button-primary" type="submit">Me Interesa <i class="flaticon-whatsapp"></i></a>
                                        </div>
                                        <div class="title">
                                            <a href="{{ route('property.show', $inmueble->id) }}" class="tf-button-primary" type="submit">Ver Detalles <i class="icon-arrow-right-add"></i></a>
                                        </div>
                                                            
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                            <div class="col-12">
                                <p>No hay inmuebles para mostrar.</p>
                            </div>
                        @endforelse
                    </div>

                    {{-- Paginación --}}
                    @if($sales->hasPages())
                    <div class="row">
                        <div class="col-12">
                            <ul class="wg-pagination justify-center wow fadeInUp">
                                @if($sales->onFirstPage())
                                    <li class="disabled"><span><i class="icon-keyboard_arrow_left"></i></span></li>
                                @else
                                    <li>
                                        <a href="{{ $sales->previousPageUrl() }}" rel="prev">
                                            <i class="icon-keyboard_arrow_left"></i>
                                        </a>
                                    </li>
                                @endif

                                @foreach($sales->links()->elements[0] as $page => $url)
                                    @if($page == $sales->currentPage())
                                        <li class="active"><span>{{ $page }}</span></li>
                                    @else
                                        <li><a href="{{ $url }}">{{ $page }}</a></li>
                                    @endif
                                @endforeach

                                @if($sales->hasMorePages())
                                    <li>
                                        <a href="{{ $sales->nextPageUrl() }}" rel="next">
                                            <i class="icon-keyboard_arrow_right"></i>
                                        </a>
                                    </li>
                                @else
                                    <li class="disabled"><span><i class="icon-keyboard_arrow_right"></i></span></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection