@extends('layouts.app' )
@section('title', 'CONFINCA - Detalle Inmueble')
@section('content')

<div class="main-content pt-150">          
                              
                <!-- property-single-wrap -->
                <div class="property-single-wrap sticky-container" data-sticky-container>
                    <div class="cl-container">
                        <div class="row">
                            <div class="col-12">
                                <div class="flex items-center justify-between gap30 flex-wrap pt-30 pb-30">                                    
                                    <div class="list-icons-page">
                                        <div class="item">
                                            <div class="icon">
                                                <i class="flaticon-outbox"></i>
                                            </div>
                                            <p>Compartir</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="wrap-gallery-image">
                                    <div class="list-tags type-1">
                                        <a href="#" class="tags-item for-sell">{{ $property->offer->name }}</a>
                                    </div>
                                    {{-- Primeras 5 imágenes visibles --}}
                                    @foreach ($property->images->take(5) as $index => $image)
                                        <a href="{{ Storage::url($image->image) }}" 
                                        class="item-{{ $index + 1 }}" 
                                        data-fancybox="gallery">
                                            <img src="{{ Storage::url($image->image) }}" alt="Imagen {{ $index + 1 }}">
                                        </a>
                                    @endforeach
                                    {{-- Imágenes ocultas (del 6 en adelante) visibles solo en fancybox --}}
                                    @foreach ($property->images->skip(5) as $image)
                                        <a href="{{ Storage::url($image->image) }}" 
                                        data-fancybox="gallery" 
                                        style="display:none">
                                            <img src="{{ Storage::url($image->image) }}" alt="Imagen propiedad">
                                        </a>
                                    @endforeach
                                    {{-- Botón ver todas --}}
                                    @if($property->images->count() > 5)
                                        <a href="{{ Storage::url($property->images->skip(5)->first()->image) }}" 
                                        class="more-photos" 
                                        data-fancybox="gallery">
                                            <i class="flaticon-gallery"></i>
                                            <p>{{ $property->images->count() }} Fotos</p>
                                        </a>
                                    @endif
                                </div>
                            </div>
                            <div class="col-xl-8">
                    <div class="content-wrap">
                        <div class="head-title wow fadeInUp">
                            <div>
                                <h3>{{ $property->typeProperty->name ?? '' }}</h3>
                                <div class="location">
                                    <div class="icon">
                                        <i class="flaticon-location"></i>
                                    </div>
                                    <div class="text-content">{{ $property->address }}</div>
                                </div>
                            </div>
                            <div>
                                <div class="price">${{ number_format($property->price) }}</div>
                            </div>
                        </div>

                        <div class="box-items">
                            <div class="item wow fadeInUp" data-wow-delay="0.2s">
                                <div class="icon"><i class="flaticon-minus-front"></i></div>
                                <div class="text-content">{{ $property->area }} m²</div>
                            </div>
                            <div class="item wow fadeInUp">
                                <div class="icon"><i class="flaticon-hotel"></i></div>
                                <div class="text-content">{{ $property->rooms }} Habitaciones</div>
                            </div>
                            <div class="item wow fadeInUp" data-wow-delay="0.1s">
                                <div class="icon"><i class="flaticon-bath-tub"></i></div>
                                <div class="text-content">{{ $property->bathrooms }} Baños</div>
                            </div>
                        </div>

                        <div class="details">
                                        <h4 class="wow fadeInUp">Detalles</h4>
                                        <div class="list-item">
                                            <div class="item wow fadeInUp">
                                                <div class="text">Código:</div>
                                                <p>{{ $property->code }}</p>
                                            </div>
                                            <div class="item wow fadeInUp" data-wow-delay="0.1s">
                                                <div class="text">Garage:</div>
                                                <p>{{ $property->parking }}</p>
                                            </div>
                                            <div class="item wow fadeInUp">
                                                <div class="text">Precio:</div>
                                                <p>${{ number_format($property->price) }}</p>
                                            </div>
                                            <div class="item wow fadeInUp" data-wow-delay="0.1s">
                                                <div class="text">Administración:</div>
                                                <p>${{ number_format($property->administration) }}</p>
                                            </div>
                                            <div class="item wow fadeInUp">
                                                <div class="text">Habitaciones:</div>
                                                <p>{{ $property->rooms }}</p>
                                            </div>
                                            <div class="item wow fadeInUp" data-wow-delay="0.1s">
                                                <div class="text">Baños:</div>
                                                <p>{{ $property->bathrooms }}</p>
                                            </div>
                                            <div class="item wow fadeInUp">
                                                <div class="text">Tipo Inmueble:</div>
                                                <p>{{ $property->typeProperty->name }}</p>
                                            </div>
                                            <div class="item wow fadeInUp" data-wow-delay="0.1s">
                                                <div class="text">Oferta:</div>
                                                <p>{{ $property->offer->name }}</p>
                                            </div>                                          
                                        </div>
                                    </div>

                        <div class="features">
                                        <ul>
                                            <li>
                                                <h5 class="wow fadeInUp">Características Internas</h5>
                                                <div class="wrap-check-ellipse wow fadeInUp" data-wow-delay="0.1s">
                                                    @foreach ( $property->internalCharacteristics  as $ichar )
                                                    <div class="check-ellipse-item">
                                                        <div class="icon">
                                                            <i class="flaticon-check"></i>
                                                        </div>
                                                        <p>{{ $ichar->name }}</p>
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </li>  
                                            <li>
                                                <h5 class="wow fadeInUp">Características Externas</h5>
                                                <div class="wrap-check-ellipse wow fadeInUp" data-wow-delay="0.1s">
                                                    @foreach ( $property->externalCharacteristics  as $echar )
                                                    <div class="check-ellipse-item">
                                                        <div class="icon">
                                                            <i class="flaticon-check"></i>
                                                        </div>
                                                        <p>{{ $echar->name }}</p>
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </li>                                                                                    
                                        </ul>
                                    </div>            

                        <div class="desc">
                            <h4 class="wow fadeInUp">Descripción</h4>
                            <p class="wow fadeInUp" align="justify">{!! $property->description !!}</p>
                        </div>

                        <div class="video">
                            <h4 class="wow fadeInUp">Video</h4>
                            @if ($property->video_url)                          
                            
                            <div class="video-wrap">
                                <img src="images/image-box/video-2.jpg" alt="">
                                <a href="{{ $property->video_url }}" class="popup-youtube">
                                    <div class="icon">
                                        <i class="flaticon-play"></i>
                                    </div>
                                </a>
                            </div>
                            @else
                                <div class="no-video-message">
                                    <i class="flaticon-video-off"></i>
                                    <p>No hay video disponible</p>
                                </div>
                            @endif
                        </div>

                        <div class="map">
                            <h4 class="wow fadeInUp">Mapa</h4>
                            <div class="wrap-map-v1">
                                <div class="mapouter"><div class="gmap_canvas"><iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=600&amp;height=600&amp;hl=en&amp;q={{ $property->latitude }},{{ $property->longitude }}&amp;t=&amp;z=18&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe><a href="https://embed-googlemap.com">google maps embed</a></div><style>.mapouter{position:relative;text-align:right;width:100%;height:600px;}.gmap_canvas {overflow:hidden;background:none!important;width:100%;height:600px;}.gmap_iframe {height:600px!important;}</style></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4">
                    <div class="property-single-sidebar po-sticky has-background">
                        <div class="sidebar-item sidebar-contact-info">
                            <div class="sidebar-title">Información de Contacto</div>
                            <div class="contact-info">
                                <div class="person">
                                    <div class="image">
                                        <img src="{{ Storage::url($property->agent->image) }}" alt="">
                                    </div>
                                    <div class="content">
                                        <div class="name">
                                            <a href="#">{{ $property->agent->name }}</a>
                                        </div>
                                        <p>{{ $property->agent->email }}</p>
                                        <p>{{ $property->agent->phone }}</p>
                                    </div>
                                </div>
                                <form class="form-comment" method="POST" action="{{ route('property.lead.store') }}">
                                    @csrf

                                    @if(session('success'))
                                        <div class="alert alert-success mb-4">{{ session('success') }}</div>
                                    @endif

                                    <input type="hidden" name="property_id" value="{{ $property->id }}">
                                    <input type="hidden" name="agent_id" value="{{ $property->agent->id }}">

                                    <div class="cols">
                                        <fieldset class="name has-top-title">
                                            <input type="text" placeholder="Nombre" name="name" required>
                                            <label>Nombre</label>
                                        </fieldset>
                                        <fieldset class="phone has-top-title">
                                            <input type="number" placeholder="Teléfono" name="phone" required>
                                            <label>Teléfono</label>
                                        </fieldset>
                                    </div>
                                    <div class="cols">
                                        <fieldset class="email has-top-title">
                                            <input type="email" placeholder="Email" name="email" required>
                                            <label>Email</label>
                                        </fieldset>
                                    </div>
                                    <div class="cols">                                        
                                        <fieldset class="message">
                                            <input type="datetime-local" 
                                                name="visit_date" 
                                                min="{{ now()->addDay()->format('Y-m-d\TH:i') }}"
                                                required>
                                        </fieldset>                                      
                                    </div>
                                    <fieldset class="message has-top-title">
                                        <textarea name="message" rows="4" placeholder="Mensaje" required></textarea>
                                        <label>Mensaje</label>
                                    </fieldset>
                                    <div class="button-submit">
                                        <button class="tf-button-primary w-full" type="submit">
                                            Enviar Mensaje<i class="icon-arrow-right-add"></i>
                                        </button>
                                    </div>
                                    <div class="flex gap20">
                                        <a href="tel:{{ $property->agent->phone }}" class="tf-button-primary w-full">
                                            Llamar<i class="flaticon-phone"></i>
                                        </a>
                                        <a href="https://wa.me/57{{ $property->agent->phone }}?text=Hola, estoy interesado en la propiedad: {{ urlencode($property->code) }}" 
                                        class="tf-button-primary w-full">
                                            WhatsApp<i class="flaticon-whatsapp"></i>
                                        </a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>  

@endsection