<div class="space-y-6" wire:key="img-manager-{{ $propertyId }}">

    {{-- Modal confirmación eliminar --}}
    @if($confirmingDelete)
        <div class="fixed inset-0 bg-gray-900/50 flex items-center justify-center z-50"
             wire:click.self="cancelDelete">
            <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-sm w-full mx-4 shadow-xl">
                <div class="flex items-center gap-3 mb-4">
                    <div class="w-10 h-10 bg-red-100 rounded-full flex items-center justify-center flex-shrink-0">
                        <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2a10 10 0 1 0 0 20A10 10 0 0 0 12 2zm0 15a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm1-4a1 1 0 1 1-2 0V8a1 1 0 1 1 2 0v5z"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">¿Eliminar imagen?</h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Esta acción no se puede deshacer.</p>
                    </div>
                </div>
                <div class="flex justify-end gap-3">
                    <button wire:click="cancelDelete"
                            class="px-4 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 rounded-lg transition">
                        Cancelar
                    </button>
                    <button wire:click="deleteImage"
                            wire:loading.attr="disabled"
                            class="px-4 py-2 text-sm font-medium text-white bg-red-600 hover:bg-red-700 rounded-lg transition disabled:opacity-50">
                        <span wire:loading.remove wire:target="deleteImage">Sí, eliminar</span>
                        <span wire:loading wire:target="deleteImage">Eliminando...</span>
                    </button>
                </div>
            </div>
        </div>
    @endif

    {{-- Subir imágenes --}}
    <div class="bg-white dark:bg-gray-100 rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-900 mb-4">Cargar Nuevas Imágenes</h3>

        <div class="space-y-4">
            <div class="border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg p-6 text-center hover:border-primary-500 transition">
                <input type="file" wire:model="newImages" multiple accept="image/*"
                       class="hidden" id="img-upload-{{ $propertyId }}">
                <label for="img-upload-{{ $propertyId }}" class="cursor-pointer block">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                    </svg>
                    <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                        <span class="font-medium text-primary-600">Click para seleccionar</span> o arrastra imágenes
                    </p>
                    <p class="text-xs text-gray-500 mt-1">Máx 5MB por imagen</p>
                </label>
            </div>

            @error('newImages.*')
                <p class="text-red-500 text-sm">{{ $message }}</p>
            @enderror

            @if(count($newImages) > 0)
                <div>
                    <p class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">
                        {{ count($newImages) }} imagen(es) seleccionada(s) —
                        <span class="text-primary-600">Click para marcar como principal:</span>
                    </p>

                    <div class="grid grid-cols-4 md:grid-cols-6 gap-3">
                        @foreach($newImages as $index => $image)
                            <div wire:click="setMainImage({{ $index }})"
                                 class="relative cursor-pointer rounded-lg overflow-hidden border-4 transition
                                        {{ $mainImageIndex == $index
                                            ? 'border-yellow-400 ring-2 ring-yellow-400'
                                            : 'border-transparent hover:border-gray-300' }}">
                                <img src="{{ $image->temporaryUrl() }}" class="w-full h-24 object-cover">

                                @if($mainImageIndex == $index)
                                    <div class="absolute inset-0 bg-yellow-400/20 flex items-center justify-center">
                                        <span class="bg-yellow-500 text-white text-xs font-bold px-2 py-1 rounded shadow">
                                            PRINCIPAL
                                        </span>
                                    </div>
                                @endif

                                <div class="absolute top-1 left-1 bg-gray-800/70 text-white text-xs w-5 h-5 flex items-center justify-center rounded-full">
                                    {{ $index + 1 }}
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="mt-4 flex gap-2">
                        <button wire:click="uploadImages"
                                wire:loading.attr="disabled"
                                class="px-4 py-2 bg-green-600 hover:bg-green-700 disabled:bg-gray-400 text-white text-sm font-medium rounded-lg flex items-center gap-2 transition">
                            <svg wire:loading.remove wire:target="uploadImages" class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                      d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                            </svg>
                            <svg wire:loading wire:target="uploadImages" class="animate-spin w-4 h-4" fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"/>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8H4z"/>
                            </svg>
                            Guardar ({{ count($newImages) }})
                        </button>
                        <button wire:click="$set('newImages', [])"
                                class="px-4 py-2 bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 text-sm font-medium rounded-lg transition">
                            Cancelar
                        </button>
                    </div>
                </div>
            @endif
        </div>
    </div>

    {{-- Galería existente --}}
    <div class="bg-white dark:bg-gray-100 rounded-lg shadow p-6">
        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-900 mb-4">
            Galería
            <span class="text-sm font-normal text-gray-500">({{ $images->count() }} imágenes)</span>
        </h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            @forelse($images as $image)
                <article class="group relative border border-gray-200 dark:border-gray-300 rounded-lg overflow-hidden hover:shadow-md transition">

                    {{-- Badge principal --}}
                    @if($image->level == 1)
                        <div class="absolute top-2 left-2 z-10 bg-yellow-500 text-white text-xs font-bold px-2 py-1 rounded shadow">
                            PRINCIPAL
                        </div>
                    @endif

                    {{-- Imagen --}}
                    <div class="aspect-[4/3] overflow-hidden">
                        <img src="{{ Storage::disk('public')->url($image->image) }}"
                             alt="Imagen propiedad"
                             class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                    </div>

                    {{-- Acciones --}}
                    <div class="p-2 flex justify-between items-center gap-2">
                        {{-- Marcar como principal --}}
                        @if($image->level != 1)
                            <button wire:click="setAsPrimary({{ $image->id }})"
                                    title="Marcar como principal"
                                    class="flex-1 text-xs text-center py-1 px-2 rounded bg-yellow-100 hover:bg-yellow-200 text-yellow-700 transition">
                                ★ Principal
                            </button>
                        @else
                            <span class="flex-1 text-xs text-center py-1 px-2 rounded bg-yellow-50 text-yellow-500">
                                ★ Principal
                            </span>
                        @endif

                        {{-- Eliminar --}}
                        <button wire:click="confirmDelete({{ $image->id }})"
                                title="Eliminar"
                                class="p-1 text-red-400 hover:text-red-600 transition">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M8.586 2.586A2 2 0 0 1 10 2h4a2 2 0 0 1 2 2v2h3a1 1 0 1 1 0 2v12a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V8a1 1 0 0 1 0-2h3V4a2 2 0 0 1 .586-1.414ZM10 6h4V4h-4v2Zm1 4a1 1 0 1 0-2 0v8a1 1 0 1 0 2 0v-8Zm4 0a1 1 0 1 0-2 0v8a1 1 0 1 0 2 0v-8Z"/>
                            </svg>
                        </button>
                    </div>
                </article>
            @empty
                <div class="col-span-full flex flex-col items-center justify-center py-12 text-gray-400">
                    <svg class="w-12 h-12 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                              d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    <p class="text-sm">No hay imágenes cargadas</p>
                </div>
            @endforelse
        </div>
    </div>
</div>