<script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>

@php
$record = $getRecord();
$availableCharacteristics = \App\Models\ExternalCharacteristics::all();
@endphp

<div x-data="{
    externalId: '',
    saving: false,
    message: '',
    messageType: '',
    
    async saveCharacteristic() {
        if (!this.externalId) {
            this.message = 'Selecciona una característica';
            this.messageType = 'warning';
            return;
        }
        
        this.saving = true;
        this.message = '';
        
        try {
            const response = await fetch('{{ route('properties.external.store', $record) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
                body: JSON.stringify({
                    property_id: {{ $record->id }},
                    external_id: this.externalId
                })
            });
            
            const data = await response.json();
            
            if (response.ok) {
                this.message = data.message || 'Característica agregada';
                this.messageType = 'success';
                this.externalId = '';
                // Disparar evento para actualizar la tabla
                window.dispatchEvent(new CustomEvent('refresh-external-table'));
            } else {
                this.message = data.message || 'Error al guardar';
                this.messageType = 'error';
            }
        } catch (error) {
            this.message = 'Error de conexión';
            this.messageType = 'error';
        } finally {
            this.saving = false;
        }
    }
}" class="space-y-4">

    {{-- Mensajes --}}
    <div x-show="message" 
         x-transition
         :class="{
             'bg-green-50 text-green-700 border-green-200': messageType === 'success',
             'bg-red-50 text-red-700 border-red-200': messageType === 'error',
             'bg-yellow-50 text-yellow-700 border-yellow-200': messageType === 'warning'
         }"
         class="p-3 rounded-lg border text-sm"
         x-text="message">
    </div>

    <div class="flex gap-4 items-end">
        <div class="flex-1">
            <label class="block text-sm font-medium text-gray-700 mb-2">
                Característica Externa
            </label>
            <select x-model="externalId" 
                class="w-full rounded-lg border-gray-300 bg-white text-gray-900 text-lg focus:border-blue-500 focus:ring-blue-500 shadow-sm">
                <option value="">Seleccionar característica...</option>
                @foreach($availableCharacteristics as $char)
                    <option value="{{ $char->id }}">{{ $char->name }}</option>
                @endforeach
            </select>
        </div>
        
        <button type="button"
            @click="saveCharacteristic()"
            :disabled="saving"
            class="inline-flex items-center px-4 py-2.5 bg-blue-600 hover:bg-blue-700 disabled:bg-blue-400 text-white text-sm font-medium rounded-lg transition-colors shadow-sm">
            <svg x-show="!saving" class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            <svg x-show="saving" class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
            <span x-text="saving ? 'Guardando...' : 'Agregar'"></span>
        </button>
    </div>
</div>