<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #16a34a; color: white; padding: 20px; text-align: center; }
        .content { padding: 30px; background: #f9f9f9; }
        .info-box { background: white; border-left: 4px solid #16a34a; padding: 15px; margin: 20px 0; }
        .footer { text-align: center; padding: 15px; font-size: 12px; color: #999; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header"><h2>✅ Visita Confirmada</h2></div>
        <div class="content">
            <p>Hola <strong>{{ $lead->name }}</strong>,</p>
            <p>Tu visita ha sido <strong>confirmada</strong>. Aquí están los detalles:</p>
            <div class="info-box">
                <p><strong>📅 Fecha y hora:</strong> {{ \Carbon\Carbon::parse($lead->visit_date)->format('d/m/Y \a \l\a\s H:i') }}</p>
                <p><strong>📍 Dirección:</strong> {{ $lead->property->address ?? '' }}</p>
            </div>
            <p>Te esperamos. Si necesitas reprogramar no dudes en contactarnos.</p>
            <br>
            <p>El equipo de <strong>Confinca</strong></p>
        </div>
        <div class="footer">Confinca - Tu aliado inmobiliario</div>
    </div>
</body>
</html>