@extends('layouts.app')

@section('title', 'CONFINCA - Nosotros')

@section('content')

<!-- flat-title -->
                @props(['imageUrl' => asset('storage/' . $banner->image)]) {{-- imagen por defecto --}}
                <section class="flat-title inner-page" style="background-image: url('{{ $imageUrl }}')">
                    <div class="cl-container full">
                        <div class="row">
                            <div class="col-12">
                                <div class="content">
                                    <h2>{{ $banner->title }}</h2>
                                    <div class="text">{{ $banner->subtitle }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /flat-title -->

                <!-- vision-mission -->
                <section class="tf-section vision-mission">
                    <div class="cl-container">
                        <div class="row">
                            <div class="col-12">
                                <div class="content">
                                    <div class="vision">
                                        <h2 class="wow fadeInUp">{{ $visionMission->titleone }}</h2>
                                        <p class="wow fadeInUp">{{ $visionMission->descriptionone }}</p>
                                    </div>
                                    <div class="mission">
                                        <h2 class=" wow fadeInUp" data-wow-delay="0.1s">{{ $visionMission->titletwo }}</h2>
                                        <p class=" wow fadeInUp" data-wow-delay="0.1s">{{ $visionMission->descriptiontwo }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /vision-mission -->

                <!-- luxury-home -->
                <section class="tf-section luxury-home style-5">
                    <div class="cl-container">
                        <div class="row justify-between">
                            <div class="col-md-6">
                                <div class="image wow fadeInLeft">
                                    <img src="{{ asset('storage/' . $sectionFinals->image) }}" alt="">
                                    <div class="box">
                                        <div class="icon">
                                            <i class="flaticon-customer"></i>
                                        </div>
                                        <div>
                                            <p>{{ $sectionFinals->titleicon }}</p>
                                            <h4>{{ $sectionFinals->subtitleicon }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-5 col-md-6">
                                <div class="content">
                                    <h2 class="wow fadeInUp">{{ $sectionFinals->title }}</h2>
                                    <div class="text-content wow fadeInUp">{{ $sectionFinals->description }}</div>
                                    <a href="{{ route($sectionFinals->buttonlink) }}" class="tf-button-primary style-black wow fadeInUp">{{ $sectionFinals->buttontext }}<i class="icon-arrow-right-add"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /luxury-home -->

@endsection