<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\TextSectionthree;
use Illuminate\Auth\Access\HandlesAuthorization;

class TextSectionthreePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:TextSectionthree');
    }

    public function view(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('View:TextSectionthree');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:TextSectionthree');
    }

    public function update(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('Update:TextSectionthree');
    }

    public function delete(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('Delete:TextSectionthree');
    }

    public function restore(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('Restore:TextSectionthree');
    }

    public function forceDelete(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('ForceDelete:TextSectionthree');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:TextSectionthree');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:TextSectionthree');
    }

    public function replicate(AuthUser $authUser, TextSectionthree $textSectionthree): bool
    {
        return $authUser->can('Replicate:TextSectionthree');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:TextSectionthree');
    }

}