<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\SectionFourTitle;
use Illuminate\Auth\Access\HandlesAuthorization;

class SectionFourTitlePolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:SectionFourTitle');
    }

    public function view(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('View:SectionFourTitle');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:SectionFourTitle');
    }

    public function update(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('Update:SectionFourTitle');
    }

    public function delete(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('Delete:SectionFourTitle');
    }

    public function restore(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('Restore:SectionFourTitle');
    }

    public function forceDelete(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('ForceDelete:SectionFourTitle');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:SectionFourTitle');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:SectionFourTitle');
    }

    public function replicate(AuthUser $authUser, SectionFourTitle $sectionFourTitle): bool
    {
        return $authUser->can('Replicate:SectionFourTitle');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:SectionFourTitle');
    }

}