<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\SectionFourRight;
use Illuminate\Auth\Access\HandlesAuthorization;

class SectionFourRightPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:SectionFourRight');
    }

    public function view(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('View:SectionFourRight');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:SectionFourRight');
    }

    public function update(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('Update:SectionFourRight');
    }

    public function delete(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('Delete:SectionFourRight');
    }

    public function restore(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('Restore:SectionFourRight');
    }

    public function forceDelete(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('ForceDelete:SectionFourRight');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:SectionFourRight');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:SectionFourRight');
    }

    public function replicate(AuthUser $authUser, SectionFourRight $sectionFourRight): bool
    {
        return $authUser->can('Replicate:SectionFourRight');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:SectionFourRight');
    }

}