<?php

declare(strict_types=1);

namespace App\Policies;

use Illuminate\Foundation\Auth\User as AuthUser;
use App\Models\SectionFourLeft;
use Illuminate\Auth\Access\HandlesAuthorization;

class SectionFourLeftPolicy
{
    use HandlesAuthorization;
    
    public function viewAny(AuthUser $authUser): bool
    {
        return $authUser->can('ViewAny:SectionFourLeft');
    }

    public function view(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('View:SectionFourLeft');
    }

    public function create(AuthUser $authUser): bool
    {
        return $authUser->can('Create:SectionFourLeft');
    }

    public function update(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('Update:SectionFourLeft');
    }

    public function delete(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('Delete:SectionFourLeft');
    }

    public function restore(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('Restore:SectionFourLeft');
    }

    public function forceDelete(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('ForceDelete:SectionFourLeft');
    }

    public function forceDeleteAny(AuthUser $authUser): bool
    {
        return $authUser->can('ForceDeleteAny:SectionFourLeft');
    }

    public function restoreAny(AuthUser $authUser): bool
    {
        return $authUser->can('RestoreAny:SectionFourLeft');
    }

    public function replicate(AuthUser $authUser, SectionFourLeft $sectionFourLeft): bool
    {
        return $authUser->can('Replicate:SectionFourLeft');
    }

    public function reorder(AuthUser $authUser): bool
    {
        return $authUser->can('Reorder:SectionFourLeft');
    }

}