<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PropertyExternal extends Model
{
    protected $fillable = [
        'property_id',
        'external_id'
    ];

    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function externalCharacteristic()
    {
        return $this->belongsTo(ExternalCharacteristics::class, 'external_characteristics_id');
    }
}
