<?php

namespace App\Mail;

use App\Models\PropertyLead;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PropertyLeadCompanyMail extends Mailable
{
    use SerializesModels;

    public function __construct(public PropertyLead $lead) {}

    public function build()
    {
        return $this->subject('Nuevo contacto - Propiedad #' . $this->lead->property->code)
                    ->view('emails.lead-company');
    }
}