<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Property;
use Illuminate\Http\Request;

class PropertyInternalController extends Controller
{
    /**
     * Obtener lista de características (para AJAX)
     */
    public function list(Property $property)
    {
        $characteristics = $property->internalCharacteristics()
            ->select('internal_characteristics.id', 'internal_characteristics.name')
            ->get();
            
        return response()->json($characteristics);
    }

    /**
     * Agregar una característica interna (AJAX)
     */
    public function store(Request $request, Property $property)
    {
        $request->validate([
            'internal_id' => 'required|exists:internal_characteristics,id',
        ]);

        // Verificar si ya existe
        $exists = $property->internalCharacteristics()
            ->where('internal_id', $request->internal_id)
            ->exists();

        if ($exists) {
            return response()->json([
                'message' => 'Esta característica ya está asignada'
            ], 422);
        }

        // Agregar la relación
        $property->internalCharacteristics()->attach($request->internal_id);

        return response()->json([
            'message' => 'Característica agregada correctamente'
        ]);
    }

    /**
     * Eliminar una característica interna (AJAX)
     */
    public function destroy(Property $property, $internal)
    {
        $property->internalCharacteristics()->detach($internal);

        return response()->json([
            'message' => 'Característica eliminada correctamente'
        ]);
    }
}