<?php

namespace App\Filament\Admin\Resources\TypeProperties\Pages;

use App\Filament\Admin\Resources\TypeProperties\TypePropertyResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditTypeProperty extends EditRecord
{
    protected static string $resource = TypePropertyResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
