<?php

namespace App\Filament\Admin\Resources\TextSectionTwos;

use App\Filament\Admin\Resources\TextSectionTwos\Pages\CreateTextSectionTwo;
use App\Filament\Admin\Resources\TextSectionTwos\Pages\EditTextSectionTwo;
use App\Filament\Admin\Resources\TextSectionTwos\Pages\ListTextSectionTwos;
use App\Filament\Admin\Resources\TextSectionTwos\Schemas\TextSectionTwoForm;
use App\Filament\Admin\Resources\TextSectionTwos\Tables\TextSectionTwosTable;
use App\Models\TextSectionTwo;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class TextSectionTwoResource extends Resource
{
    protected static ?string $model = TextSectionTwo::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Dos - Texto';
    protected static ?int    $navigationSort  = 1;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getPluralLabel(): string
    {
        return 'Texto sección dos';
    }

    public static function getLabel(): string
    {
        return 'Texto sección dos';
    }

    

    public static function form(Schema $schema): Schema
    {
        return TextSectionTwoForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return TextSectionTwosTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListTextSectionTwos::route('/'),
            'create' => CreateTextSectionTwo::route('/create'),
            'edit' => EditTextSectionTwo::route('/{record}/edit'),
        ];
    }
}
