<?php

namespace App\Filament\Admin\Resources\SectionFourRights;

use App\Filament\Admin\Resources\SectionFourRights\Pages\CreateSectionFourRight;
use App\Filament\Admin\Resources\SectionFourRights\Pages\EditSectionFourRight;
use App\Filament\Admin\Resources\SectionFourRights\Pages\ListSectionFourRights;
use App\Filament\Admin\Resources\SectionFourRights\Schemas\SectionFourRightForm;
use App\Filament\Admin\Resources\SectionFourRights\Tables\SectionFourRightsTable;
use App\Models\SectionFourRight;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class SectionFourRightResource extends Resource
{
    protected static ?string $model = SectionFourRight::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Cuatro - Derecha';
    protected static ?int    $navigationSort  = 8;    

    public static function getPluralLabel(): string
    {
        return 'Sección cuatro derecha';
    }

    public static function getLabel(): string
    {
        return 'Sección cuatro derecha';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return SectionFourRightForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return SectionFourRightsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSectionFourRights::route('/'),
            'create' => CreateSectionFourRight::route('/create'),
            'edit' => EditSectionFourRight::route('/{record}/edit'),
        ];
    }
}
