<?php

namespace App\Filament\Admin\Resources\SectionFourRights\Schemas;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class SectionFourRightForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('icon')
                    ->label('Ícono')
                    ->required(),
                Textarea::make('title')
                    ->label('Título')
                    ->required()
                    ->columnSpanFull(),
                Textarea::make('description')
                    ->label('Descripción')
                    ->required()
                    ->columnSpanFull(),
            ]);
    }
}
