<?php

namespace App\Filament\Admin\Resources\SectionFourLefts;

use App\Filament\Admin\Resources\SectionFourLefts\Pages\CreateSectionFourLeft;
use App\Filament\Admin\Resources\SectionFourLefts\Pages\EditSectionFourLeft;
use App\Filament\Admin\Resources\SectionFourLefts\Pages\ListSectionFourLefts;
use App\Filament\Admin\Resources\SectionFourLefts\Schemas\SectionFourLeftForm;
use App\Filament\Admin\Resources\SectionFourLefts\Tables\SectionFourLeftsTable;
use App\Models\SectionFourLeft;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class SectionFourLeftResource extends Resource
{
    protected static ?string $model = SectionFourLeft::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Cuatro - Izquierda';
    protected static ?int    $navigationSort  = 6;    

    public static function getPluralLabel(): string
    {
        return 'Sección cuatro';
    }

    public static function getLabel(): string
    {
        return 'Sección cuatro';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return SectionFourLeftForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return SectionFourLeftsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListSectionFourLefts::route('/'),
            'create' => CreateSectionFourLeft::route('/create'),
            'edit' => EditSectionFourLeft::route('/{record}/edit'),
        ];
    }
}
