<?php

namespace App\Filament\Admin\Resources\PropertyStatuses;

use App\Filament\Admin\Resources\PropertyStatuses\Pages\CreatePropertyStatus;
use App\Filament\Admin\Resources\PropertyStatuses\Pages\EditPropertyStatus;
use App\Filament\Admin\Resources\PropertyStatuses\Pages\ListPropertyStatuses;
use App\Filament\Admin\Resources\PropertyStatuses\Schemas\PropertyStatusForm;
use App\Filament\Admin\Resources\PropertyStatuses\Tables\PropertyStatusesTable;
use App\Models\PropertyStatus;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class PropertyStatusResource extends Resource
{
    protected static ?string $model = PropertyStatus::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedExclamationCircle;

    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 4;

    public static function getPluralLabel(): string
    {
        return 'Estado Inmueble';
    }

    public static function getLabel(): string
    {
        return 'Estado Inmueble';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return PropertyStatusForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PropertyStatusesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPropertyStatuses::route('/'),
            'create' => CreatePropertyStatus::route('/create'),
            'edit' => EditPropertyStatus::route('/{record}/edit'),
        ];
    }
}
