<?php

namespace App\Filament\Admin\Resources\PropertyLeads\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class PropertyLeadForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Nombre')
                    ->required(),
                TextInput::make('phone')
                    ->label('Teléfono')
                    ->tel()
                    ->required(),
                TextInput::make('email')
                    ->label('Email')
                    ->email()
                    ->required(),
                Textarea::make('message')
                    ->label('Mensaje')
                    ->columnSpanFull(),
                DateTimePicker::make('visit_date')->label('Fecha Visita'),
                Select::make('status')
                    ->label('Estado')
                    ->options(['pendiente' => 'Pendiente', 'confirmado' => 'Confirmado'])
                    ->default('pendiente')
                    ->required(),
                Select::make('property_id')
                    ->label('Propiedad')
                    ->relationship('property', 'code')
                    ->required(),

                Select::make('agent_id')
                    ->label('Agente')
                    ->relationship('agent', 'name')
                    ->required(),
            ]);
    }
}
