<?php

namespace App\Filament\Admin\Resources\PropertyLeads;

use App\Filament\Admin\Resources\PropertyLeads\Pages\CreatePropertyLead;
use App\Filament\Admin\Resources\PropertyLeads\Pages\EditPropertyLead;
use App\Filament\Admin\Resources\PropertyLeads\Pages\ListPropertyLeads;
use App\Filament\Admin\Resources\PropertyLeads\Schemas\PropertyLeadForm;
use App\Filament\Admin\Resources\PropertyLeads\Tables\PropertyLeadsTable;
use App\Mail\PropertyLeadConfirmedMail;
use App\Models\PropertyLead;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Support\Facades\Mail;

use Filament\Actions\Action;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;

use Filament\Forms\Form;

class PropertyLeadResource extends Resource
{
    protected static ?string $model = PropertyLead::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedUserCircle;

    protected static string|UnitEnum|null $navigationGroup  = 'Posibles Clientes';
    protected static ?int    $navigationSort  = 1;

    public static function getPluralLabel(): string
    {
        return 'Clientes';
    }

    public static function getLabel(): string
    {
        return 'Cliente';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return PropertyLeadForm::configure($schema);
    }

    

    /*public static function table(Table $table): Table
    {
        return PropertyLeadsTable::configure($table);
    }*/

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')->label('Nombre')->searchable(),
                TextColumn::make('phone')->label('Teléfono'),
                TextColumn::make('email')->label('Email')->searchable(),
                TextColumn::make('property.code')->label('Propiedad'),
                TextColumn::make('agent.name')->label('Agente'),
                TextColumn::make('visit_date')
                    ->label('Fecha visita')
                    ->dateTime('d/m/Y H:i')
                    ->sortable(),
                TextColumn::make('status')
                    ->label('Estado')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        'pendiente'  => 'warning',
                        'confirmado' => 'success',
                    }),
                TextColumn::make('created_at')
                    ->label('Recibido')
                    ->dateTime('d/m/Y H:i')
                    ->sortable(),
            ])
            ->defaultSort('created_at', 'desc')
            ->actions([
                EditAction::make()
                    ->iconButton(),

                Action::make('whatsapp')
                    ->label('WhatsApp')
                    ->iconButton()
                    ->icon('heroicon-o-chat-bubble-left-ellipsis')
                    ->color('success')
                    ->url(fn (PropertyLead $record): string => 
                        'https://wa.me/57' . preg_replace('/\D/', '', $record->phone) .
                        '?text=' . urlencode(
                            "Hola {$record->name}, te confirmamos tu visita para el " .
                            \Carbon\Carbon::parse($record->visit_date)->format('d/m/Y \a \l\a\s H:i') .
                            " en la dirección: {$record->property->address}. ¡Te esperamos! - Confinca"
                        )
                    )
                    ->openUrlInNewTab(),

                DeleteAction::make()
                    ->iconButton(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPropertyLeads::route('/'),
            'create' => CreatePropertyLead::route('/create'),
            'edit' => EditPropertyLead::route('/{record}/edit'),
        ];
    }
}
