<?php

namespace App\Filament\Admin\Resources\Properties\Schemas;


use Filament\Actions\Action;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Filament\Schemas\Components\Tabs;
use Filament\Schemas\Components\Tabs\Tab;
use App\Models\InternalCharacteristic;
use App\Models\ExternalCharacteristic;
use App\Models\InternalCharacteristics;
use Filament\Forms\Components;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Form;
use Filament\Support\Components\ViewComponent;
use Filament\Tables;
use Filament\Tables\Table;
use PHPUnit\Metadata\Test;
use Filament\Infolists\Components\ViewEntry;
use App\Models\PropertyInternalCharacteristic; // Asume que tienes este modelo pivot
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Schemas\Components\Actions;
use Illuminate\Database\Eloquent\Relations\Pivot;
use App\Livewire\InternalCharacteristicsManager;
use App\Livewire\PropertyImageGallery;
use App\Models\Property;
use Filament\Forms\Components\FileUpload;
use Filament\Schemas\Components\Livewire;
use Cheesegrits\FilamentGoogleMaps\Infolists\MapEntry;


class PropertyInfolist
{
    public static function configure(Schema $schema): Schema
    //public static function form(Form $form): Form
    {
        return $schema

            ->components([
                Tabs::make('Tabs')
                    ->columnSpanFull()
                    ->tabs([
                        self::getGeneralTab(),
                        self::getInternalCharacteristicsTab(),
                        self::getExternalCharacteristicsTab(),
                        self::getImagesTab(),
                    ])
                    ->activeTab(1),
            ]);
    }

    private static function getGeneralTab(): Tab
    {
        
        return Tab::make('Datos Generales')
                ->icon('heroicon-o-home')
                ->columns(2)
                ->schema([
                                Section::make('Información Básica')
                                    ->description('Datos principales del inmueble')
                                    ->columnSpanFull()
                                    ->columns(2)
                                    ->icon('heroicon-m-home')
                                    ->schema([
                                        TextEntry::make('code')
                                            ->label('Código')
                                            ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                ',
                                            ])
                                            ->copyable()
                                            ->disabled(),
                                        TextEntry::make('state')
                                            ->label('Estado')
                                            ->badge() // ✅ Método badge(), no BadgeEntry
                                            ->colors([
                                                'success' => 'Activo',
                                                'danger' => 'Inactivo',
                                            ]),
                                        TextEntry::make('propertyStatus.name')
                                                ->label('Estado del Inmueble')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]),
                                        TextEntry::make('offer.name')
                                                ->label('Oferta')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]),    
                                        TextEntry::make('typeProperty.name')
                                                ->label('Tipo de Inmueble')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]),
                                        TextEntry::make('agent.name')
                                                ->label('Agente')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]), 
                                        TextEntry::make('owner.name')
                                                ->label('Propietario')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]),     
                                        TextEntry::make('video_url')
                                                ->label('Video')
                                                ->extraAttributes([
                                                'class' => 'filament-forms-text-input-component',
                                                'style' => '
                                                    background-color: #f3f4f6 !important;
                                                    border: 1px solid #d1d5db !important;
                                                    border-radius: 0.5rem !important;
                                                    padding: 0.625rem 0.875rem !important;
                                                    color: #374151 !important;
                                                    cursor: not-allowed !important;
                                                    opacity: 1 !important;
                                                    ',
                                                ]),  

                                    Section::make('Detalles del Inmueble')
                                        ->description('Características y descripción del inmueble')
                                        ->icon('heroicon-m-information-circle')
                                        ->columnSpanFull()
                                        ->columns(2)
                                        ->schema([ 

                                                TextEntry::make('price')
                                                    ->label('Precio')
                                                    ->numeric()
                                                    ->prefix('$')
                                                    ->suffix('COP')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]), 

                                                TextEntry::make( 'adminitration')
                                                    ->label('Administración')
                                                    ->numeric()
                                                    ->prefix('$')
                                                    ->suffix('COP')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),    

                                                TextEntry::make('rooms')
                                                    ->label('Habitaciones')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),    
                                                
                                                TextEntry::make('bathrooms')
                                                    ->label('Baños')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),
                                                
                                                TextEntry::make('parking')
                                                    ->label('Parqueaderos')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),

                                                TextEntry::make('area')
                                                    ->label('Área (m²)')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),    

                                                TextEntry::make('city.name')
                                                    ->label('Ciudad')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),

                                                TextEntry::make('neighborhood.name')
                                                    ->label('Barrio')
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',
                                                    ]),

                                                TextEntry::make('description')
                                                    ->label('Descripción')
                                                    ->html() 
                                                    ->columnSpanFull()
                                                    ->extraAttributes([
                                                    'class' => 'filament-forms-text-input-component',
                                                    'style' => '
                                                        background-color: #f3f4f6 !important;
                                                        border: 1px solid #d1d5db !important;
                                                        border-radius: 0.5rem !important;
                                                        padding: 0.625rem 0.875rem !important;
                                                        color: #374151 !important;
                                                        cursor: not-allowed !important;
                                                        opacity: 1 !important;
                                                        ',  
                                                    ]),
    

                                                ]),  
                                                
                                        Section::make('Ubicación')
                                            ->description('Datos de la ubicación del inmueble')
                                            ->icon('heroicon-m-map')
                                            ->columnSpanFull()
                                            ->columns(2)
                                            ->schema([    
                                                MapEntry::make('location')
                                                    ->mapControls([
                                                        'mapTypeControl'    => true,
                                                        'scaleControl'      => true,
                                                        'streetViewControl' => true,
                                                        'rotateControl'     => true,
                                                        'fullscreenControl' => true,
                                                        'searchBoxControl'  => true,
                                                        'zoomControl'       => true,
                                                    ])
                                                    ->height('500px')
                                                    ->defaultZoom(15)
                                                    ->defaultLocation(fn ($record) => [
                                                                $record?->latitude ?? 7.115143,
                                                                $record?->longitude ?? -73.125769,
                                                                ]) 
                                                    ->columnSpanFull(),

                                            ]),                         

                                ]),   

                                
                                 
                            
                            ]);

    }

    private static function getInternalCharacteristicsTab(): Tab
    {
        return Tab::make('Características Internas')
            ->icon('heroicon-o-home-modern')
            ->schema([
                Section::make('Asignar Característica')
                    ->schema([
                        ViewEntry::make('internal_form')
                            ->label('')
                            ->view('filament.internal'),
                    ]),

                Section::make('Características Asignadas')
                    ->schema([
                        ViewEntry::make('internal_list')
                            ->label('')
                            ->view('filament.internalTable'),
                    ]),
            ]);
    }

    private static function getExternalCharacteristicsTab(): Tab
    {
        return Tab::make('Características Externas')
            ->icon('heroicon-o-home-modern')
            ->schema([
                Section::make('Asignar Característica')
                    ->schema([
                        ViewEntry::make('external_form')
                            ->label('')
                            ->view('filament.external'),
                    ]),

                Section::make('Características Asignadas')
                    ->schema([
                        ViewEntry::make('external_list')
                            ->label('')
                            ->view('filament.externalTable'),
                    ]),
            ]);
    }

    

    private static function getImagesTab(): Tab
    {
        return Tab::make('Imágen')
            ->icon('heroicon-o-photo')
            ->schema([
                Section::make('Imágenes')
                    ->schema([
                        Livewire::make(PropertyImageGallery::class, fn ($record) => [
                            'propertyId' => $record->id,
                        ])
                        ->key('property-image-gallery')
                        ->columnSpanFull(),
                    ]),
                
            ]);
    }

}
            
    




