<?php

namespace App\Filament\Admin\Resources\Posts\Schemas;

use Filament\Infolists\Components\ImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class PostInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('category.name')
                    ->label('Categoría')
                    ->numeric()
                    ->placeholder('-'),
                TextEntry::make('title'),
                TextEntry::make('slug'),
                TextEntry::make('excerpt')
                    ->placeholder('-')
                    ->columnSpanFull(),
                TextEntry::make('created_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('updated_at')
                    ->dateTime()
                    ->placeholder('-'),
                TextEntry::make('content')
                    ->placeholder('-')
                    ->columnSpanFull(),
                ImageEntry::make('cover_image')
                    ->placeholder('-'),
                //TextEntry::make('is_published'),
                TextEntry::make('is_published')
                    ->label('Estado')
                    ->badge()
                    ->colors([
                        'success' => fn ($state) => (bool) $state,
                        'danger'  => fn ($state) => !(bool) $state,
                    ])
                    ->formatStateUsing(fn ($state) => $state ? 'Publicado' : 'Borrador'),
                TextEntry::make('published_at')
                    ->dateTime()
                    ->placeholder('-'),
            ]);
    }
}
