<?php

namespace App\Filament\Admin\Resources\Posts\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\RichEditor;

class PostForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                /*TextInput::make('category_id')
                    ->numeric()
                    ->default(null),*/
                Select::make('category_id')    
                    ->label('Categoría')
                    ->relationship('category', 'name') // muestra "name" y guarda el ID
                    ->searchable()
                    ->preload()
                    ->required(),
                TextInput::make('title')
                     ->label('Titulo')
                    ->required(),
                TextInput::make('slug')
                    ->required(),
                Textarea::make('excerpt')
                    ->label('Descripción corta')
                    ->default(null)
                    ->columnSpanFull(),

                RichEditor::make('content')
                    ->label('Contenido')
                    ->extraAttributes([
                        'style' => 'height: 500px; min-height: 500px;',
                    ])
                    ->columnSpanFull()
                    ->fileAttachmentsDirectory('posts/attachments') // opcional: para adjuntos 
                    ->required(),

                FileUpload::make('cover_image')
                    ->label('Imagen de portada')
                    ->image(),
                TextInput::make('is_published')
                    ->label('Publicado')
                    ->required()
                    ->default('0'),
                DateTimePicker::make('published_at')
                    ->label('Fecha de publicación')
                    ->default(null),
            ]);
    }
}
