<?php

namespace App\Filament\Admin\Resources\Offers;

use App\Filament\Admin\Resources\Offers\Pages\CreateOffer;
use App\Filament\Admin\Resources\Offers\Pages\EditOffer;
use App\Filament\Admin\Resources\Offers\Pages\ListOffers;
use App\Filament\Admin\Resources\Offers\Schemas\OfferForm;
use App\Filament\Admin\Resources\Offers\Tables\OffersTable;
use App\Models\Offer;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class OfferResource extends Resource
{
    protected static ?string $model = Offer::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedHomeModern;

    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 5;

    public static function getPluralLabel(): string
    {
        return 'Oferta';
    }

    public static function getLabel(): string
    {
        return 'Oferta';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return OfferForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return OffersTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListOffers::route('/'),
            'create' => CreateOffer::route('/create'),
            'edit' => EditOffer::route('/{record}/edit'),
        ];
    }
}
