<?php

namespace App\Filament\Admin\Resources\Neighborhoods;

use App\Filament\Admin\Resources\Neighborhoods\Pages\CreateNeighborhood;
use App\Filament\Admin\Resources\Neighborhoods\Pages\EditNeighborhood;
use App\Filament\Admin\Resources\Neighborhoods\Pages\ListNeighborhoods;
use App\Filament\Admin\Resources\Neighborhoods\Schemas\NeighborhoodForm;
use App\Filament\Admin\Resources\Neighborhoods\Tables\NeighborhoodsTable;
use App\Models\Neighborhood;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class NeighborhoodResource extends Resource
{
    protected static ?string $model = Neighborhood::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedFlag;

    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 3;

    public static function getPluralLabel(): string
    {
        return 'barrios';
    }

    public static function getLabel(): string
    {
        return 'barrio';
    }


    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return NeighborhoodForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return NeighborhoodsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListNeighborhoods::route('/'),
            'create' => CreateNeighborhood::route('/create'),
            'edit' => EditNeighborhood::route('/{record}/edit'),
        ];
    }
}
