<?php

namespace App\Filament\Admin\Resources\InternalCharacteristics;

use App\Filament\Admin\Resources\InternalCharacteristics\Pages\CreateInternalCharacteristics;
use App\Filament\Admin\Resources\InternalCharacteristics\Pages\EditInternalCharacteristics;
use App\Filament\Admin\Resources\InternalCharacteristics\Pages\ListInternalCharacteristics;
use App\Filament\Admin\Resources\InternalCharacteristics\Schemas\InternalCharacteristicsForm;
use App\Filament\Admin\Resources\InternalCharacteristics\Tables\InternalCharacteristicsTable;
use App\Models\InternalCharacteristics;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class InternalCharacteristicsResource extends Resource
{
    protected static ?string $model = InternalCharacteristics::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCheckCircle;

    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 7;

    public static function getPluralLabel(): string
    {
        return 'Características Internas';
    }

    public static function getLabel(): string
    {
        return 'Característica Interna';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return InternalCharacteristicsForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return InternalCharacteristicsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListInternalCharacteristics::route('/'),
            'create' => CreateInternalCharacteristics::route('/create'),
            'edit' => EditInternalCharacteristics::route('/{record}/edit'),
        ];
    }
}
