<?php

namespace App\Filament\Admin\Resources\ExternalCharacteristics\Pages;

use App\Filament\Admin\Resources\ExternalCharacteristics\ExternalCharacteristicsResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditExternalCharacteristics extends EditRecord
{
    protected static string $resource = ExternalCharacteristicsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        // Esto redirige a la página de listado
        return $this->getResource()::getUrl('index');
    }
}
