<?php

namespace App\Filament\Admin\Resources\ExternalCharacteristics;

use App\Filament\Admin\Resources\ExternalCharacteristics\Pages\CreateExternalCharacteristics;
use App\Filament\Admin\Resources\ExternalCharacteristics\Pages\EditExternalCharacteristics;
use App\Filament\Admin\Resources\ExternalCharacteristics\Pages\ListExternalCharacteristics;
use App\Filament\Admin\Resources\ExternalCharacteristics\Schemas\ExternalCharacteristicsForm;
use App\Filament\Admin\Resources\ExternalCharacteristics\Tables\ExternalCharacteristicsTable;
use App\Models\ExternalCharacteristics;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ExternalCharacteristicsResource extends Resource
{
    protected static ?string $model = ExternalCharacteristics::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedCheckCircle;

    protected static string|UnitEnum|null $navigationGroup  = 'Inmuebles';
    protected static ?int    $navigationSort  = 7;

    public static function getPluralLabel(): string
    {
        return 'Características Externas';
    }

    public static function getLabel(): string
    {
        return 'Característica Externa';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return ExternalCharacteristicsForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ExternalCharacteristicsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListExternalCharacteristics::route('/'),
            'create' => CreateExternalCharacteristics::route('/create'),
            'edit' => EditExternalCharacteristics::route('/{record}/edit'),
        ];
    }
}
