<?php

namespace App\Filament\Admin\Resources\ColumnsSectionTwos;

use App\Filament\Admin\Resources\ColumnsSectionTwos\Pages\CreateColumnsSectionTwo;
use App\Filament\Admin\Resources\ColumnsSectionTwos\Pages\EditColumnsSectionTwo;
use App\Filament\Admin\Resources\ColumnsSectionTwos\Pages\ListColumnsSectionTwos;
use App\Filament\Admin\Resources\ColumnsSectionTwos\Schemas\ColumnsSectionTwoForm;
use App\Filament\Admin\Resources\ColumnsSectionTwos\Tables\ColumnsSectionTwosTable;
use App\Models\ColumnsSectionTwo;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class ColumnsSectionTwoResource extends Resource
{
    protected static ?string $model = ColumnsSectionTwo::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedViewColumns;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?string $navigationLabel = 'Sección Dos - Columnas';
    protected static ?int    $navigationSort  = 2;    

    public static function getPluralLabel(): string
    {
        return 'Columnas sección dos';
    }

    public static function getLabel(): string
    {
        return 'Columna sección dos';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return ColumnsSectionTwoForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return ColumnsSectionTwosTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListColumnsSectionTwos::route('/'),
            'create' => CreateColumnsSectionTwo::route('/create'),
            'edit' => EditColumnsSectionTwo::route('/{record}/edit'),
        ];
    }
}
