<?php

namespace App\Filament\Admin\Resources\BannerHomes;

use App\Filament\Admin\Resources\BannerHomes\Pages\CreateBannerHome;
use App\Filament\Admin\Resources\BannerHomes\Pages\EditBannerHome;
use App\Filament\Admin\Resources\BannerHomes\Pages\ListBannerHomes;
use App\Filament\Admin\Resources\BannerHomes\Schemas\BannerHomeForm;
use App\Filament\Admin\Resources\BannerHomes\Tables\BannerHomesTable;
use App\Models\BannerHome;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class BannerHomeResource extends Resource
{
    protected static ?string $model = BannerHome::class;

    protected static string|UnitEnum|null $navigationGroup  = 'Inicio';
    protected static ?int    $navigationSort  = 1;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedPhoto;

    protected static ?string $recordTitleAttribute = 'name';

    public static function getPluralLabel(): string
    {
        return 'Banner Inicio';
    }

    public static function getLabel(): string
    {
        return 'Banner Inicio';
    }

    public static function form(Schema $schema): Schema
    {
        return BannerHomeForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BannerHomesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBannerHomes::route('/'),
            'create' => CreateBannerHome::route('/create'),
            'edit' => EditBannerHome::route('/{record}/edit'),
        ];
    }
}
