<?php

namespace App\Filament\Admin\Resources\BannerAbouts\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class BannerAboutForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                FileUpload::make('image')
                    ->label('Imagen (1898x840)')
                    ->image()
                    ->required(),
                TextInput::make('title')
                    ->label('Título')
                    ->required(),
                TextInput::make('subtitle')
                    ->label('Subtítulo')
                    ->required(),
            ]);
    }
}
