<?php

namespace App\Filament\Admin\Resources\BannerAbouts;

use App\Filament\Admin\Resources\BannerAbouts\Pages\CreateBannerAbout;
use App\Filament\Admin\Resources\BannerAbouts\Pages\EditBannerAbout;
use App\Filament\Admin\Resources\BannerAbouts\Pages\ListBannerAbouts;
use App\Filament\Admin\Resources\BannerAbouts\Schemas\BannerAboutForm;
use App\Filament\Admin\Resources\BannerAbouts\Tables\BannerAboutsTable;
use App\Models\BannerAbout;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class BannerAboutResource extends Resource
{
    protected static ?string $model = BannerAbout::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedPhoto;

    protected static string|UnitEnum|null $navigationGroup  = 'Nosotros';
    protected static ?int    $navigationSort  = 1;

    public static function getPluralLabel(): string
    {
        return 'Banner Nosotros';
    }

    public static function getLabel(): string
    {
        return 'Banner Nosotros';
    }


    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return BannerAboutForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return BannerAboutsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListBannerAbouts::route('/'),
            'create' => CreateBannerAbout::route('/create'),
            'edit' => EditBannerAbout::route('/{record}/edit'),
        ];
    }
}
