<?php

namespace App\Filament\Admin\Resources\Agents;

use App\Filament\Admin\Resources\Agents\Pages\CreateAgent;
use App\Filament\Admin\Resources\Agents\Pages\EditAgent;
use App\Filament\Admin\Resources\Agents\Pages\ListAgents;
use App\Filament\Admin\Resources\Agents\Schemas\AgentForm;
use App\Filament\Admin\Resources\Agents\Tables\AgentsTable;
use App\Models\Agent;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class AgentResource extends Resource
{
    protected static ?string $model = Agent::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedUserCircle;

    protected static string|UnitEnum|null $navigationGroup  = 'Agentes';

    protected static ?int    $navigationSort  = 1;

    public static function getPluralLabel(): string
    {
        return 'Agentes';
    }

    public static function getLabel(): string
    {
        return 'Agente';
    }

    
    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return AgentForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AgentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAgents::route('/'),
            'create' => CreateAgent::route('/create'),
            'edit' => EditAgent::route('/{record}/edit'),
        ];
    }
}
