<?php

namespace App\Filament\Admin\Resources\AboutSectionFinals\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class AboutSectionFinalForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('icon')
                    ->required(),
                TextInput::make('titleicon')
                    ->required(),
                TextInput::make('subtitleicon')
                    ->required(),
                FileUpload::make('image')
                    ->image()
                    ->required(),
                TextInput::make('title')
                    ->required(),
                Textarea::make('description')
                    ->required()
                    ->columnSpanFull(),
                TextInput::make('buttontext')
                    ->required(),
                TextInput::make('buttonlink')
                    ->required(),
            ]);
    }
}
