<?php

namespace App\Filament\Admin\Resources\AboutSectionFinals;

use App\Filament\Admin\Resources\AboutSectionFinals\Pages\CreateAboutSectionFinal;
use App\Filament\Admin\Resources\AboutSectionFinals\Pages\EditAboutSectionFinal;
use App\Filament\Admin\Resources\AboutSectionFinals\Pages\ListAboutSectionFinals;
use App\Filament\Admin\Resources\AboutSectionFinals\Schemas\AboutSectionFinalForm;
use App\Filament\Admin\Resources\AboutSectionFinals\Tables\AboutSectionFinalsTable;
use App\Models\AboutSectionFinal;
use BackedEnum;
use UnitEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class AboutSectionFinalResource extends Resource
{
    protected static ?string $model = AboutSectionFinal::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentText;

    protected static string|UnitEnum|null $navigationGroup  = 'Nosotros';
    protected static ?int    $navigationSort  = 3;

    public static function getPluralLabel(): string
    {
        return 'Nosotros - Sección Final';
    }

    public static function getLabel(): string
    {
        return 'Nosotros - Sección Final';
    }

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return AboutSectionFinalForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AboutSectionFinalsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAboutSectionFinals::route('/'),
            'create' => CreateAboutSectionFinal::route('/create'),
            'edit' => EditAboutSectionFinal::route('/{record}/edit'),
        ];
    }
}
